-- Convert RGB to HSV

viewer.mode=FULLSCREEN

function setup()
    boxTab={} -- table of input/output boxes
    table.insert(boxTab,input(WIDTH/2-100,HEIGHT-200,90,30,1,"R"))  
    table.insert(boxTab,input(WIDTH/2-100,HEIGHT-275,90,30,1,"G"))  
    table.insert(boxTab,input(WIDTH/2-100,HEIGHT-350,90,30,1,"B"))      
    table.insert(boxTab,input(WIDTH/2,HEIGHT-200,90,30,2,"H"))  
    table.insert(boxTab,input(WIDTH/2,HEIGHT-275,90,30,2,"S"))  
    table.insert(boxTab,input(WIDTH/2,HEIGHT-350,90,30,2,"V"))     
    table.insert(boxTab,input(WIDTH/2+100,HEIGHT-275,90,30,2,"RGB Hex"))      
end

function draw()
    background(32, 59, 83)         -- screen color
    pushStyle()
    fontSize(36)
    text("RGB to HSV Converter",WIDTH/2,HEIGHT-50)   -- draw text
    popStyle()
    fill(224, 149, 127, 255)            -- set color
    text("( Tap each R, G, B box to input values )",WIDTH/2,HEIGHT-100)
    for a,b in pairs(boxTab) do             -- loop thru table  
        b:draw()                            -- draw each box
    end
    R=tonumber(boxTab[1].val)
    G=tonumber(boxTab[2].val)
    B=tonumber(boxTab[3].val)  
    convert()    
    boxTab[4].val=string.format("%d°",h//1)
    boxTab[5].val=string.format("%d%%",s*100//1)
    boxTab[6].val=string.format("%d%%",v*100//1)
    boxTab[7].val=string.format("%02X%02X%02X",R//1,G//1,B//1)
end

function touched(t)                     -- check which box is selected
    for nbr,box in pairs(boxTab) do     -- loop thru table
        if box:touched(t) then          -- box touched
            return                      -- exit function
        end
    end  
end

function keyboard(k)
    for nbr,box in pairs(boxTab) do -- loop thru table
        box:keyboard(k)             -- get input from box
    end  
end

function convert()
    local r,g,b=math.tointeger(R)/255,math.tointeger(G)/255,math.tointeger(B)/255
    local max,min=math.max(r,g,b),math.min(r,g,b)
    local c=max-min 
    v=max  
    if c==0 then
        h=0
    else
        if max==r then
            h=(((g-b)/c)%6)*60
        end
        if max==g then
            h=(((b-r)/c)+2)*60
        end
        if max==b then
            h=(((r-g)/c)+4)*60
        end
    end    
    if max==0 then
        s=0
    else
        s=c/max
    end    
end

input=class()

function input:init(x,y,w,h,type,txt)
    self.x=x            -- x position
    self.y=y            -- y position
    self.w=w            -- width
    self.h=h            -- height
    self.type=type      -- 1=input box  2=output box
    self.txt=txt        -- text to show above box
    self.val="0"        -- data keyed in box
    self.sel=false      -- box selected true/false
end

function input:draw()
    pushStyle()
    rectMode(CENTER)
    textMode(CENTER)
    fill(0)                         -- set background for box
    if self.sel then                    -- set selected color for box
        fill(105, 101, 31, 255)
    end
    stroke(255, 66, 0, 255)         -- box outline color
    strokeWidth(2)                      -- outline size
    rect(self.x,self.y,self.w,self.h)   -- draw box
    fill(255)                       -- set text color
    text(self.txt,self.x,self.y+self.h) -- box name
    text(self.val,self.x+4,self.y)      -- box text
    popStyle()
end

function input:keyboard(k)
    if self.sel then
        if k==BACKSPACE then            -- backspace key pressed
            str=str:sub(1,str:len()-1)  -- remove last digit
            if #str==0 then
                str="0"
            end
        elseif k>="0" and k<="9" then   -- only digits 1 thru 9
            if str:sub(1,1)=="0" then   -- check if leading 0
                str=""                  -- clear leading 0
            end
            str=str..k                  -- update keyed value
        end
        self.val=str                    -- save keyed value
    end
end

function input:touched(t)
    if t.state==BEGAN then
        if not isKeyboardShowing() then
            showKeyboard()      -- show keyboard if its not displayed
        end 
        str="0"                 -- set to 0
        for z=1,#boxTab do      -- clear selected flag for all boxes
            boxTab[z].sel=false
        end
        -- check which box was selected
        if t.x>self.x-self.w/2 and t.x<self.x+self.w/2 and
                t.y>self.y-self.h/2 and t.y<self.y+self.h/2 and self.type==1 then
            self.val="0"        -- reset val
            self.sel=true       -- set selected flag
            return true         -- box selected
        end
    end 
    return false                -- no box selected
end

