-- SARS-CoV-2-Wastewater

local function onRDraw(img)
    plot = img
    
end

local function draw()
    -- remember: Codea y axis starts from bottom like R but unlike lua
    background(0,0,0)
    fill(255,255,255,255)
    -- draw white backgrounds for plots
    rect(WIDTH * 0.28, HEIGHT-300, 360, 360)
    rect(WIDTH * 0.72, HEIGHT-300, 360, 360)   
    if plot1 then
        sprite(plot1,WIDTH * 0.28,HEIGHT-300, 360, 360)
    end
    if plot2 then
        sprite(plot2,WIDTH * 0.72,HEIGHT-300, 360, 360)
    end
end

function setup()
    viewer.mode = FULLSCREEN
    --note: the next statement gets the actual UIViewController running in Codea
    local vc = objc.viewer
    
    -- setup labels
    titleLabel = objc.UILabel()
    subtitleLabel = objc.UILabel()
    cityLabelOne = objc.UILabel()
    startLabelOne = objc.UILabel()
    endLabelOne = objc.UILabel()
    cityLabelTwo = objc.UILabel()
    startLabelTwo = objc.UILabel()
    endLabelTwo = objc.UILabel()
    cityLabelResultOne = objc.UILabel()
    startLabelResultOne = objc.UILabel()
    endLabelResultOne = objc.UILabel()
    cityLabelResultTwo = objc.UILabel()
    startLabelResultTwo = objc.UILabel()
    endLabelResultTwo = objc.UILabel()
    titleLabel.text = "SARS-CoV-2-Wastewater Concentrations"
    subtitleLabel.text = "Specific City Sewersheds (normalized viral genomic copies/person) 12/1/2021+"
    cityLabelOne.text = "City #1"
    startLabelOne.text = "Start Date"
    endLabelOne.text = "End Date"
    cityLabelTwo.text = "City #2"
    startLabelTwo.text = "Start Date"
    endLabelTwo.text = "End Date"
    cityLabelResultOne.text = " set city "
    startLabelResultOne.text = " set start "
    endLabelResultOne.text = " set end "
    cityLabelResultTwo.text = " set city "
    startLabelResultTwo.text = " set start "
    endLabelResultTwo.text = " set end "
    titleLabel.textColor = color(255,255,255)
    subtitleLabel.textColor = color(255,255,255)
    cityLabelOne.textColor = color(255,255,255)
    startLabelOne.textColor = color(255,255,255)
    endLabelOne.textColor = color(255,255,255)
    cityLabelTwo.textColor = color(255,255,255)
    startLabelTwo.textColor = color(255,255,255)
    endLabelTwo.textColor = color(255,255,255)
    cityLabelResultOne.textColor = color(0,0,0)
    startLabelResultOne.textColor = color(0,0,0)
    endLabelResultOne.textColor = color(0,0,0)
    cityLabelResultTwo.textColor = color(0,0,0)
    startLabelResultTwo.textColor = color(0,0,0)
    endLabelResultTwo.textColor = color(0,0,0)
    cityLabelResultOne.backgroundColor = color(255,255,255)
    startLabelResultOne.backgroundColor = color(255,255,255)
    endLabelResultOne.backgroundColor = color(255,255,255)
    cityLabelResultTwo.backgroundColor = color(255,255,255)
    startLabelResultTwo.backgroundColor = color(255,255,255)
    endLabelResultTwo.backgroundColor = color(255,255,255)
    titleLabel.font = objc.UIFont:systemFontOfSize_(40)
    vc.view:addSubview_(titleLabel)
    vc.view:addSubview_(subtitleLabel)
    vc.view:addSubview_(cityLabelOne)
    vc.view:addSubview_(startLabelOne)
    vc.view:addSubview_(endLabelOne)
    vc.view:addSubview_(cityLabelTwo)
    vc.view:addSubview_(startLabelTwo)
    vc.view:addSubview_(endLabelTwo)
    vc.view:addSubview_(cityLabelResultOne)
    vc.view:addSubview_(startLabelResultOne)
    vc.view:addSubview_(endLabelResultOne)
    vc.view:addSubview_(cityLabelResultTwo)
    vc.view:addSubview_(startLabelResultTwo)
    vc.view:addSubview_(endLabelResultTwo)
    titleLabel.translatesAutoresizingMaskIntoConstraints = false
    subtitleLabel.translatesAutoresizingMaskIntoConstraints = false
    cityLabelOne.translatesAutoresizingMaskIntoConstraints = false
    startLabelOne.translatesAutoresizingMaskIntoConstraints = false
    endLabelOne.translatesAutoresizingMaskIntoConstraints = false
    cityLabelTwo.translatesAutoresizingMaskIntoConstraints = false
    startLabelTwo.translatesAutoresizingMaskIntoConstraints = false
    endLabelTwo.translatesAutoresizingMaskIntoConstraints = false
    cityLabelResultOne.translatesAutoresizingMaskIntoConstraints = false
    startLabelResultOne.translatesAutoresizingMaskIntoConstraints = false
    endLabelResultOne.translatesAutoresizingMaskIntoConstraints = false
    cityLabelResultTwo.translatesAutoresizingMaskIntoConstraints = false
    startLabelResultTwo.translatesAutoresizingMaskIntoConstraints = false
    endLabelResultTwo.translatesAutoresizingMaskIntoConstraints = false
    titleLabel.topAnchor:constraintEqualToAnchor_constant_(vc.view.topAnchor, 40).active = true
    titleLabel.centerXAnchor:constraintEqualToAnchor_(vc.view.centerXAnchor).active = true
    subtitleLabel.topAnchor:constraintEqualToAnchor_constant_(titleLabel.bottomAnchor, 5).active = true
    subtitleLabel.centerXAnchor:constraintEqualToAnchor_(vc.view.centerXAnchor).active = true
    cityLabelOne.topAnchor:constraintEqualToAnchor_constant_(titleLabel.bottomAnchor, 400).active = true
    cityLabelOne.leadingAnchor:constraintEqualToAnchor_constant_(vc.view.centerXAnchor, -(WIDTH*0.32)).active = true
    startLabelOne.topAnchor:constraintEqualToAnchor_constant_(titleLabel.bottomAnchor, 400).active = true
    startLabelOne.leadingAnchor:constraintEqualToAnchor_constant_(cityLabelOne.trailingAnchor, 75).active = true
    endLabelOne.topAnchor:constraintEqualToAnchor_constant_(titleLabel.bottomAnchor, 400).active = true
    endLabelOne.leadingAnchor:constraintEqualToAnchor_constant_(startLabelOne.trailingAnchor, 75).active = true
    cityLabelTwo.topAnchor:constraintEqualToAnchor_constant_(titleLabel.bottomAnchor, 400).active = true
    cityLabelTwo.leadingAnchor:constraintEqualToAnchor_constant_(endLabelOne.trailingAnchor, 75).active = true
    startLabelTwo.topAnchor:constraintEqualToAnchor_constant_(titleLabel.bottomAnchor, 400).active = true
    startLabelTwo.leadingAnchor:constraintEqualToAnchor_constant_(cityLabelTwo.trailingAnchor, 75).active = true
    endLabelTwo.topAnchor:constraintEqualToAnchor_constant_(titleLabel.bottomAnchor, 400).active = true
    endLabelTwo.leadingAnchor:constraintEqualToAnchor_constant_(startLabelTwo.trailingAnchor, 75).active = true
    cityLabelResultOne.topAnchor:constraintEqualToAnchor_constant_(cityLabelOne.bottomAnchor, 30).active = true
    cityLabelResultOne.leadingAnchor:constraintEqualToAnchor_(cityLabelOne.leadingAnchor).active = true
    startLabelResultOne.topAnchor:constraintEqualToAnchor_constant_(startLabelOne.bottomAnchor, 30).active = true
    startLabelResultOne.leadingAnchor:constraintEqualToAnchor_(startLabelOne.leadingAnchor).active = true
    endLabelResultOne.topAnchor:constraintEqualToAnchor_constant_(endLabelOne.bottomAnchor, 30).active = true
    endLabelResultOne.leadingAnchor:constraintEqualToAnchor_(endLabelOne.leadingAnchor).active = true
    cityLabelResultTwo.topAnchor:constraintEqualToAnchor_constant_(cityLabelTwo.bottomAnchor, 30).active = true
    cityLabelResultTwo.leadingAnchor:constraintEqualToAnchor_(cityLabelTwo.leadingAnchor).active = true
    startLabelResultTwo.topAnchor:constraintEqualToAnchor_constant_(startLabelTwo.bottomAnchor, 30).active = true
    startLabelResultTwo.leadingAnchor:constraintEqualToAnchor_(startLabelTwo.leadingAnchor).active = true
    endLabelResultTwo.topAnchor:constraintEqualToAnchor_constant_(endLabelTwo.bottomAnchor, 30).active = true
    endLabelResultTwo.leadingAnchor:constraintEqualToAnchor_(endLabelTwo.leadingAnchor).active = true
    
    -- setup date pickers
    local minDate = objc.NSDate:alloc():initWithTimeIntervalSince1970_(1638345601) -- = 12/1/21 (date surveillance consistent)
    local maxDate = objc.NSDate() -- = today's date
    dateStartPickerOne = objc.UIDatePicker()
    dateEndPickerOne = objc.UIDatePicker()
    dateStartPickerTwo = objc.UIDatePicker()
    dateEndPickerTwo = objc.UIDatePicker()
    dateStartPickerOne.preferredDatePickerStyle = objc.enum.UIDatePickerStyle.wheels
    dateEndPickerOne.preferredDatePickerStyle = objc.enum.UIDatePickerStyle.wheels
    dateStartPickerTwo.preferredDatePickerStyle = objc.enum.UIDatePickerStyle.wheels
    dateEndPickerTwo.preferredDatePickerStyle = objc.enum.UIDatePickerStyle.wheels
    dateStartPickerOne.backgroundColor = color(255,255,255)
    dateEndPickerOne.backgroundColor = color(255,255,255)
    dateStartPickerTwo.backgroundColor = color(255,255,255)
    dateEndPickerTwo.backgroundColor = color(255,255,255)
    dateStartPickerOne.datePickerMode = objc.enum.UIDatePickerMode.date
    dateEndPickerOne.datePickerMode = objc.enum.UIDatePickerMode.date
    dateStartPickerTwo.datePickerMode = objc.enum.UIDatePickerMode.date
    dateEndPickerTwo.datePickerMode = objc.enum.UIDatePickerMode.date
    dateStartPickerOne.minimumDate = minDate
    dateStartPickerOne.maximumDate = maxDate
    dateEndPickerOne.minimumDate = minDate
    dateEndPickerOne.maximumDate = maxDate
    dateStartPickerTwo.minimumDate = minDate
    dateStartPickerTwo.maximumDate = maxDate
    dateEndPickerTwo.minimumDate = minDate
    dateEndPickerTwo.maximumDate = maxDate
    local dateFormatter = objc.NSDateFormatter:alloc():init()
    dateFormatter.dateStyle = objc.enum.NSDateFormatterStyle.NSDateFormatterShortStyle
    dateFormatter.timeStyle = objc.enum.NSDateFormatterStyle.NSDateFormatterNoStyle
    dateStartPickerOne.hidden = true
    dateEndPickerOne.hidden = true
    dateStartPickerTwo.hidden = true
    dateEndPickerTwo.hidden = true
    vc.view:addSubview_(dateStartPickerOne)
    vc.view:addSubview_(dateEndPickerOne)
    vc.view:addSubview_(dateStartPickerTwo)
    vc.view:addSubview_(dateEndPickerTwo)
    dateStartPickerOne.translatesAutoresizingMaskIntoConstraints = false
    dateEndPickerOne.translatesAutoresizingMaskIntoConstraints = false
    dateStartPickerTwo.translatesAutoresizingMaskIntoConstraints = false
    dateEndPickerTwo.translatesAutoresizingMaskIntoConstraints = false
    dateStartPickerOne.leadingAnchor:constraintEqualToAnchor_(startLabelResultOne.leadingAnchor).active = true
    dateStartPickerOne.topAnchor:constraintEqualToAnchor_constant_(startLabelResultOne.bottomAnchor, 50).active = true
    dateStartPickerOne.heightAnchor:constraintEqualToConstant_(100).active = true
    dateStartPickerOne.widthAnchor:constraintEqualToConstant_(300).active = true
    dateEndPickerOne.leadingAnchor:constraintEqualToAnchor_(endLabelResultOne.leadingAnchor).active = true
    dateEndPickerOne.topAnchor:constraintEqualToAnchor_constant_(endLabelResultOne.bottomAnchor, 50).active = true
    dateEndPickerOne.heightAnchor:constraintEqualToConstant_(100).active = true
    dateEndPickerOne.widthAnchor:constraintEqualToConstant_(300).active = true
    dateStartPickerTwo.trailingAnchor:constraintEqualToAnchor_(startLabelResultTwo.trailingAnchor).active = true
    dateStartPickerTwo.topAnchor:constraintEqualToAnchor_constant_(startLabelResultTwo.bottomAnchor, 50).active = true
    dateStartPickerTwo.heightAnchor:constraintEqualToConstant_(100).active = true
    dateStartPickerTwo.widthAnchor:constraintEqualToConstant_(300).active = true
    dateEndPickerTwo.trailingAnchor:constraintEqualToAnchor_(endLabelResultTwo.trailingAnchor).active = true
    dateEndPickerTwo.topAnchor:constraintEqualToAnchor_constant_(endLabelResultTwo.bottomAnchor, 50).active = true
    dateEndPickerTwo.heightAnchor:constraintEqualToConstant_(100).active = true
    dateEndPickerTwo.widthAnchor:constraintEqualToConstant_(300).active = true
    
    -- setup city pickers
    DelegateCityPicker = objc.delegate("UIPickerViewDelegate")
    DataSourceCityPicker = objc.delegate("UIPickerViewDataSource")
    cityData = {" Seattle "," Los Angeles "," Detroit "," Dallas ", " New Orleans ", " Atlanta ", " New York City ", " Boston "}
    -- note: one sewershed was picked per city; there maybe > 1 per city-- for approximate location of sewersheds picked go to:
    -- https://covid.cdc.gov/covid-data-tracker/#wastewater-surveillance and scroll to the "Wastewater Metric Map"
    citySewershedCodeData = {"_wa_2419_","_ca_215_","_mi_898_","_tx_1210_","_la_727_","_ga_1663_","_ny_500_","_ma_1780_"}
    function DataSourceCityPicker:numberOfComponentsInPickerView_(objPickerView)
        return 1
    end
    function DataSourceCityPicker:pickerView_numberOfRowsInComponent_(objPickerView, intComponent)
        return #cityData[intComponent+1] 
    end
    function DelegateCityPicker:pickerView_viewForRow_forComponent_reusingView_(objPickerView, intRow, intComponent, objView)
        local label = objc.UILabel()
        label.font = objc.UIFont:systemFontOfSize_weight_(26,300)
        label.textColor = color(0,0,0)
        label.text = cityData[intRow+1]
        return label
    end 
    -- note: if you don't need to resize picker text size, use the following simpler Delegate method instead of above method:
    -- function Delegate:pickerView_titleForRow_forComponent_(objPickerView, intRow, intComponent)
    --      return data[intComponent+1][intRow + 1] -- compensates for lua index being Objc Index + 1
    -- end
    
    cityPickerOne = objc.UIPickerView()
    cityPickerTwo = objc.UIPickerView() 
    cityPickerOne.delegate = DelegateCityPicker()
    cityPickerTwo.delegate = DelegateCityPicker()
    cityPickerOne.dataSource = DataSourceCityPicker()
    cityPickerTwo.dataSource = DataSourceCityPicker()
    cityPickerOne.backgroundColor = color(255,255,255)
    cityPickerTwo.backgroundColor = color(255,255,255)
    cityPickerOne.textColor = color(0,0,0)
    cityPickerTwo.textColor = color(0,0,0)
    cityPickerOne.hidden = true
    cityPickerTwo.hidden = true
    vc.view:addSubview_(cityPickerOne)
    vc.view:addSubview_(cityPickerTwo)
    cityPickerOne.translatesAutoresizingMaskIntoConstraints = false
    cityPickerTwo.translatesAutoresizingMaskIntoConstraints = false
    cityPickerOne.leadingAnchor:constraintEqualToAnchor_(cityLabelResultOne.leadingAnchor).active = true
    cityPickerOne.topAnchor:constraintEqualToAnchor_constant_(cityLabelResultOne.bottomAnchor, 50).active = true
    cityPickerOne.heightAnchor:constraintEqualToConstant_(100).active = true
    cityPickerOne.widthAnchor:constraintEqualToConstant_(300).active = true
    cityPickerTwo.trailingAnchor:constraintEqualToAnchor_(cityLabelResultTwo.trailingAnchor).active = true
    cityPickerTwo.topAnchor:constraintEqualToAnchor_constant_(cityLabelResultTwo.bottomAnchor, 50).active = true
    cityPickerTwo.heightAnchor:constraintEqualToConstant_(100).active = true
    cityPickerTwo.widthAnchor:constraintEqualToConstant_(300).active = true
    
    -- setup buttons (for city [2], dateStart, dateEnd, dateStart, dateEnd [2]: change, save, cancel actions)
    local uiButton = objc.UIButton
    local cityChangeActionOne = objc.UIAction:actionWithHandler_(function(objAction) cityPickerOne.hidden = false; citySaveButtonOne.hidden = false; cityCancelButtonOne.hidden = false; cityPickerTwo.hidden = true; citySaveButtonTwo.hidden = true; cityCancelButtonTwo.hidden = true; dateStartPickerOne.hidden = true; dateStartSaveButtonOne.hidden = true; dateStartCancelButtonOne.hidden = true; dateEndPickerOne.hidden = true;  dateEndSaveButtonOne.hidden = true; dateEndCancelButtonOne.hidden = true; dateStartPickerTwo.hidden = true; dateStartSaveButtonTwo.hidden = true; dateStartCancelButtonTwo.hidden = true; dateEndPickerTwo.hidden = true; dateEndSaveButtonTwo.hidden = true; dateEndCancelButtonTwo.hidden = true; end)
    local citySaveActionOne = objc.UIAction:actionWithHandler_(function(objAction) cityLabelResultOne.text = cityData[(cityPickerOne:selectedRowInComponent_(0))+1] end)
    local cityCancelActionOne = objc.UIAction:actionWithHandler_(function(objAction) cityPickerOne.hidden, citySaveButtonOne.hidden, cityCancelButtonOne.hidden = true,true,true end)
    local cityChangeActionTwo = objc.UIAction:actionWithHandler_(function(objAction) cityPickerOne.hidden = true; citySaveButtonOne.hidden = true; cityCancelButtonOne.hidden = true; cityPickerTwo.hidden = false; citySaveButtonTwo.hidden = false; cityCancelButtonTwo.hidden = false; dateStartPickerOne.hidden = true; dateStartSaveButtonOne.hidden = true; dateStartCancelButtonOne.hidden = true; dateEndPickerOne.hidden = true;  dateEndSaveButtonOne.hidden = true; dateEndCancelButtonOne.hidden = true; dateStartPickerTwo.hidden = true; dateStartSaveButtonTwo.hidden = true; dateStartCancelButtonTwo.hidden = true; dateEndPickerTwo.hidden = true; dateEndSaveButtonTwo.hidden = true; dateEndCancelButtonTwo.hidden = true; end)
    local citySaveActionTwo = objc.UIAction:actionWithHandler_(function(objAction) cityLabelResultTwo.text = cityData[(cityPickerTwo:selectedRowInComponent_(0))+1] end)
    local cityCancelActionTwo = objc.UIAction:actionWithHandler_(function(objAction) cityPickerTwo.hidden, citySaveButtonTwo.hidden, cityCancelButtonTwo.hidden = true,true,true end)
    local dateStartChangeActionOne = objc.UIAction:actionWithHandler_(function(objAction) cityPickerOne.hidden = true; citySaveButtonOne.hidden = true; cityCancelButtonOne.hidden = true; cityPickerTwo.hidden = true; citySaveButtonTwo.hidden = true; cityCancelButtonTwo.hidden = true; dateStartPickerOne.hidden = false; dateStartSaveButtonOne.hidden = false; dateStartCancelButtonOne.hidden = false; dateEndPickerOne.hidden = true;  dateEndSaveButtonOne.hidden = true; dateEndCancelButtonOne.hidden = true; dateStartPickerTwo.hidden = true; dateStartSaveButtonTwo.hidden = true; dateStartCancelButtonTwo.hidden = true; dateEndPickerTwo.hidden = true; dateEndSaveButtonTwo.hidden = true; dateEndCancelButtonTwo.hidden = true; end)
    local dateStartSaveActionOne = objc.UIAction:actionWithHandler_(function(objAction) startLabelResultOne.text = dateFormatter:stringFromDate_(dateStartPickerOne.date)  end)
    local dateStartCancelActionOne = objc.UIAction:actionWithHandler_(function(objAction) dateStartPickerOne.hidden, dateStartSaveButtonOne.hidden, dateStartCancelButtonOne.hidden = true,true,true end)
    local dateEndChangeActionOne = objc.UIAction:actionWithHandler_(function(objAction) cityPickerOne.hidden = true; citySaveButtonOne.hidden = true; cityCancelButtonOne.hidden = true; cityPickerTwo.hidden = true; citySaveButtonTwo.hidden = true; cityCancelButtonTwo.hidden = true; dateStartPickerOne.hidden = true; dateStartSaveButtonOne.hidden = true; dateStartCancelButtonOne.hidden = true; dateEndPickerOne.hidden = false;  dateEndSaveButtonOne.hidden = false; dateEndCancelButtonOne.hidden = false; dateStartPickerTwo.hidden = true; dateStartSaveButtonTwo.hidden = true; dateStartCancelButtonTwo.hidden = true; dateEndPickerTwo.hidden = true; dateEndSaveButtonTwo.hidden = true; dateEndCancelButtonTwo.hidden = true; end)
    local dateEndSaveActionOne = objc.UIAction:actionWithHandler_(function(objAction) endLabelResultOne.text = dateFormatter:stringFromDate_(dateEndPickerOne.date)  end)
    local dateEndCancelActionOne = objc.UIAction:actionWithHandler_(function(objAction) dateEndPickerOne.hidden, dateEndSaveButtonOne.hidden, dateEndCancelButtonOne.hidden = true,true,true end)
    local dateStartChangeActionTwo = objc.UIAction:actionWithHandler_(function(objAction) cityPickerOne.hidden = true; citySaveButtonOne.hidden = true; cityCancelButtonOne.hidden = true; cityPickerTwo.hidden = true; citySaveButtonTwo.hidden = true; cityCancelButtonTwo.hidden = true; dateStartPickerOne.hidden = true; dateStartSaveButtonOne.hidden = true; dateStartCancelButtonOne.hidden = true; dateEndPickerOne.hidden = true;  dateEndSaveButtonOne.hidden = true; dateEndCancelButtonOne.hidden = true; dateStartPickerTwo.hidden = false; dateStartSaveButtonTwo.hidden = false; dateStartCancelButtonTwo.hidden = false; dateEndPickerTwo.hidden = true; dateEndSaveButtonTwo.hidden = true; dateEndCancelButtonTwo.hidden = true; end)
    local dateStartSaveActionTwo = objc.UIAction:actionWithHandler_(function(objAction) startLabelResultTwo.text = dateFormatter:stringFromDate_(dateStartPickerTwo.date) end)
    local dateStartCancelActionTwo = objc.UIAction:actionWithHandler_(function(objAction) dateStartPickerTwo.hidden, dateStartSaveButtonTwo.hidden, dateStartCancelButtonTwo.hidden = true,true,true end)
    local dateEndChangeActionTwo = objc.UIAction:actionWithHandler_(function(objAction) cityPickerOne.hidden = true; citySaveButtonOne.hidden = true; cityCancelButtonOne.hidden = true; cityPickerTwo.hidden = true; citySaveButtonTwo.hidden = true; cityCancelButtonTwo.hidden = true; dateStartPickerOne.hidden = true; dateStartSaveButtonOne.hidden = true; dateStartCancelButtonOne.hidden = true; dateEndPickerOne.hidden = true;  dateEndSaveButtonOne.hidden = true; dateEndCancelButtonOne.hidden = true; dateStartPickerTwo.hidden = true; dateStartSaveButtonTwo.hidden = true; dateStartCancelButtonTwo.hidden = true; dateEndPickerTwo.hidden = false; dateEndSaveButtonTwo.hidden = false; dateEndCancelButtonTwo.hidden = false; end)
    local dateEndSaveActionTwo = objc.UIAction:actionWithHandler_(function(objAction) endLabelResultTwo.text = dateFormatter:stringFromDate_(dateEndPickerTwo.date) end)
    local dateEndCancelActionTwo = objc.UIAction:actionWithHandler_(function(objAction) dateEndPickerTwo.hidden, dateEndSaveButtonTwo.hidden, dateEndCancelButtonTwo.hidden = true,true,true end)
    local updateGraphActionOne = objc.UIAction:actionWithHandler_(function(objAction) updateGraphOne() end) 
    local updateGraphActionTwo = objc.UIAction:actionWithHandler_(function(objAction) updateGraphTwo() end) 
    cityChangeButtonOne= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, cityChangeActionOne)
    citySaveButtonOne= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, citySaveActionOne)
    cityCancelButtonOne= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, cityCancelActionOne)
    cityChangeButtonTwo= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, cityChangeActionTwo)
    citySaveButtonTwo= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, citySaveActionTwo)
    cityCancelButtonTwo= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, cityCancelActionTwo)
    dateStartChangeButtonOne= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateStartChangeActionOne)
    dateStartSaveButtonOne= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateStartSaveActionOne)
    dateStartCancelButtonOne= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateStartCancelActionOne)
    dateEndChangeButtonOne= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateEndChangeActionOne)
    dateEndSaveButtonOne= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateEndSaveActionOne)
    dateEndCancelButtonOne= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateEndCancelActionOne)
    dateStartChangeButtonTwo= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateStartChangeActionTwo)
    dateStartSaveButtonTwo= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateStartSaveActionTwo)
    dateStartCancelButtonTwo= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateStartCancelActionTwo)
    dateEndChangeButtonTwo= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateEndChangeActionTwo)
    dateEndSaveButtonTwo= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateEndSaveActionTwo)
    dateEndCancelButtonTwo= uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, dateEndCancelActionTwo)  
    updateGraphButtonOne = uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, updateGraphActionOne)
    updateGraphButtonTwo = uiButton:buttonWithType_primaryAction_(objc.enum.UIButtonType.system, updateGraphActionTwo)
    cityChangeButtonOne:setTitle_forState_(" change ", objc.enum.UIControlState.normal)
    citySaveButtonOne:setTitle_forState_(" save                             ", objc.enum.UIControlState.normal)
    cityCancelButtonOne:setTitle_forState_("                         cancel ", objc.enum.UIControlState.normal)
    cityChangeButtonTwo:setTitle_forState_(" change ", objc.enum.UIControlState.normal)
    citySaveButtonTwo:setTitle_forState_(" save                             ", objc.enum.UIControlState.normal)
    cityCancelButtonTwo:setTitle_forState_("                         cancel ", objc.enum.UIControlState.normal)
    dateStartChangeButtonOne:setTitle_forState_(" change ", objc.enum.UIControlState.normal)
    dateStartSaveButtonOne:setTitle_forState_(" save                             ", objc.enum.UIControlState.normal)
    dateStartCancelButtonOne:setTitle_forState_("                         cancel ", objc.enum.UIControlState.normal)
    dateEndChangeButtonOne:setTitle_forState_(" change ", objc.enum.UIControlState.normal)
    dateEndSaveButtonOne:setTitle_forState_(" save                             ", objc.enum.UIControlState.normal)
    dateEndCancelButtonOne:setTitle_forState_("                         cancel ", objc.enum.UIControlState.normal)
    dateStartChangeButtonTwo:setTitle_forState_(" change ", objc.enum.UIControlState.normal)
    dateStartSaveButtonTwo:setTitle_forState_(" save                             ", objc.enum.UIControlState.normal)
    dateStartCancelButtonTwo:setTitle_forState_("                         cancel ", objc.enum.UIControlState.normal)
    dateEndChangeButtonTwo:setTitle_forState_(" change ", objc.enum.UIControlState.normal)
    dateEndSaveButtonTwo:setTitle_forState_(" save                             ", objc.enum.UIControlState.normal)
    dateEndCancelButtonTwo:setTitle_forState_("                         cancel ", objc.enum.UIControlState.normal)   
    updateGraphButtonOne:setTitle_forState_(" update graph ", objc.enum.UIControlState.normal)
    updateGraphButtonTwo:setTitle_forState_(" update graph ", objc.enum.UIControlState.normal)
    cityChangeButtonOne:setTitleColor_forState_(color(255,165,0), objc.enum.UIControlState.normal)
    cityChangeButtonTwo:setTitleColor_forState_(color(255,165,0), objc.enum.UIControlState.normal)
    dateStartChangeButtonOne:setTitleColor_forState_(color(255,165,0), objc.enum.UIControlState.normal)
    dateEndChangeButtonOne:setTitleColor_forState_(color(255,165,0), objc.enum.UIControlState.normal)
    dateStartChangeButtonTwo:setTitleColor_forState_(color(255,165,0), objc.enum.UIControlState.normal)
    dateEndChangeButtonTwo:setTitleColor_forState_(color(255,165,0), objc.enum.UIControlState.normal)
    citySaveButtonOne:setTitleColor_forState_(color(0,0,255))
    citySaveButtonTwo:setTitleColor_forState_(color(0,0,255))
    dateStartSaveButtonOne:setTitleColor_forState_(color(0,0,255))
    dateEndSaveButtonOne:setTitleColor_forState_(color(0,0,255))
    dateStartSaveButtonTwo:setTitleColor_forState_(color(0,0,255))
    dateEndSaveButtonTwo:setTitleColor_forState_(color(0,0,255))
    cityCancelButtonOne:setTitleColor_forState_(color(255,0,0))
    cityCancelButtonTwo:setTitleColor_forState_(color(255,0,0))
    dateStartCancelButtonOne:setTitleColor_forState_(color(255,0,0))
    dateEndCancelButtonOne:setTitleColor_forState_(color(255,0,0))
    dateStartCancelButtonTwo:setTitleColor_forState_(color(255,0,0))
    dateEndCancelButtonTwo:setTitleColor_forState_(color(255,0,0))
    updateGraphButtonOne:setTitleColor_forState_(color(255,165,0), objc.enum.UIControlState.normal)
    updateGraphButtonTwo:setTitleColor_forState_(color(255,165,0), objc.enum.UIControlState.normal)
    cityChangeButtonOne:setBackgroundColor_(color(220,220,220))
    cityChangeButtonTwo:setBackgroundColor_(color(220,220,220)) 
    dateStartChangeButtonOne:setBackgroundColor_(color(220,220,220))
    dateEndChangeButtonOne:setBackgroundColor_(color(220,220,220)) 
    dateStartChangeButtonTwo:setBackgroundColor_(color(220,220,220))
    dateEndChangeButtonTwo:setBackgroundColor_(color(220,220,220)) 
    citySaveButtonOne:setBackgroundColor_(color(220,220,220))
    citySaveButtonTwo:setBackgroundColor_(color(220,220,220))
    dateStartSaveButtonOne:setBackgroundColor_(color(220,220,220))
    dateEndSaveButtonOne:setBackgroundColor_(color(220,220,220))
    dateStartSaveButtonTwo:setBackgroundColor_(color(220,220,220))
    dateEndSaveButtonTwo:setBackgroundColor_(color(220,220,220))
    cityCancelButtonOne:setBackgroundColor_(color(220,220,220))
    cityCancelButtonTwo:setBackgroundColor_(color(220,220,220))
    dateStartCancelButtonOne:setBackgroundColor_(color(220,220,220))
    dateEndCancelButtonOne:setBackgroundColor_(color(220,220,220))
    dateStartCancelButtonTwo:setBackgroundColor_(color(220,220,220))
    dateEndCancelButtonTwo:setBackgroundColor_(color(220,220,220))
    updateGraphButtonOne:setBackgroundColor_(color(220,220,220))
    updateGraphButtonTwo:setBackgroundColor_(color(220,220,220))
    citySaveButtonOne.hidden = true
    citySaveButtonTwo.hidden = true
    dateStartSaveButtonOne.hidden = true
    dateEndSaveButtonOne.hidden = true
    dateStartSaveButtonTwo.hidden = true
    dateEndSaveButtonTwo.hidden = true   
    cityCancelButtonOne.hidden = true
    cityCancelButtonTwo.hidden = true
    dateStartCancelButtonOne.hidden = true
    dateEndCancelButtonOne.hidden = true
    dateStartCancelButtonTwo.hidden = true
    dateEndCancelButtonTwo.hidden = true
    vc.view:addSubview_(cityChangeButtonOne)
    vc.view:addSubview_(citySaveButtonOne)
    vc.view:addSubview_(cityCancelButtonOne)
    vc.view:addSubview_(cityChangeButtonTwo)
    vc.view:addSubview_(citySaveButtonTwo)
    vc.view:addSubview_(cityCancelButtonTwo)
    vc.view:addSubview_(dateStartChangeButtonOne)
    vc.view:addSubview_(dateStartSaveButtonOne)
    vc.view:addSubview_(dateStartCancelButtonOne)
    vc.view:addSubview_(dateEndChangeButtonOne)
    vc.view:addSubview_(dateEndSaveButtonOne)
    vc.view:addSubview_(dateEndCancelButtonOne)
    vc.view:addSubview_(dateStartChangeButtonTwo)
    vc.view:addSubview_(dateStartSaveButtonTwo)
    vc.view:addSubview_(dateStartCancelButtonTwo)
    vc.view:addSubview_(dateEndChangeButtonTwo)
    vc.view:addSubview_(dateEndSaveButtonTwo)
    vc.view:addSubview_(dateEndCancelButtonTwo)
    vc.view:addSubview_(updateGraphButtonOne)
    vc.view:addSubview_(updateGraphButtonTwo)
    cityChangeButtonOne.translatesAutoresizingMaskIntoConstraints = false
    citySaveButtonOne.translatesAutoresizingMaskIntoConstraints = false
    cityCancelButtonOne.translatesAutoresizingMaskIntoConstraints = false
    cityChangeButtonTwo.translatesAutoresizingMaskIntoConstraints = false
    citySaveButtonTwo.translatesAutoresizingMaskIntoConstraints = false
    cityCancelButtonTwo.translatesAutoresizingMaskIntoConstraints = false
    dateStartChangeButtonOne.translatesAutoresizingMaskIntoConstraints = false
    dateStartSaveButtonOne.translatesAutoresizingMaskIntoConstraints = false
    dateStartCancelButtonOne.translatesAutoresizingMaskIntoConstraints = false
    dateEndChangeButtonOne.translatesAutoresizingMaskIntoConstraints = false
    dateEndSaveButtonOne.translatesAutoresizingMaskIntoConstraints = false
    dateEndCancelButtonOne.translatesAutoresizingMaskIntoConstraints = false
    dateStartChangeButtonTwo.translatesAutoresizingMaskIntoConstraints = false
    dateStartSaveButtonTwo.translatesAutoresizingMaskIntoConstraints = false
    dateStartCancelButtonTwo.translatesAutoresizingMaskIntoConstraints = false
    dateEndChangeButtonTwo.translatesAutoresizingMaskIntoConstraints = false
    dateEndSaveButtonTwo.translatesAutoresizingMaskIntoConstraints = false
    dateEndCancelButtonTwo.translatesAutoresizingMaskIntoConstraints = false
    updateGraphButtonOne.translatesAutoresizingMaskIntoConstraints = false
    updateGraphButtonTwo.translatesAutoresizingMaskIntoConstraints = false
    cityChangeButtonOne.leadingAnchor:constraintEqualToAnchor_(cityLabelResultOne.leadingAnchor).active = true
    cityChangeButtonOne.topAnchor:constraintEqualToAnchor_constant_(cityLabelResultOne.bottomAnchor, 10).active = true
    cityChangeButtonTwo.leadingAnchor:constraintEqualToAnchor_(cityLabelResultTwo.leadingAnchor).active = true
    cityChangeButtonTwo.topAnchor:constraintEqualToAnchor_constant_(cityLabelResultTwo.bottomAnchor, 10).active = true
    dateStartChangeButtonOne.leadingAnchor:constraintEqualToAnchor_(startLabelResultOne.leadingAnchor).active = true
    dateStartChangeButtonOne.topAnchor:constraintEqualToAnchor_constant_(startLabelResultOne.bottomAnchor, 10).active = true
    dateEndChangeButtonOne.leadingAnchor:constraintEqualToAnchor_(endLabelResultOne.leadingAnchor).active = true
    dateEndChangeButtonOne.topAnchor:constraintEqualToAnchor_constant_(endLabelResultOne.bottomAnchor, 10).active = true 
    dateStartChangeButtonTwo.leadingAnchor:constraintEqualToAnchor_(startLabelResultTwo.leadingAnchor).active = true
    dateStartChangeButtonTwo.topAnchor:constraintEqualToAnchor_constant_(startLabelResultTwo.bottomAnchor, 10).active = true
    dateEndChangeButtonTwo.leadingAnchor:constraintEqualToAnchor_(endLabelResultTwo.leadingAnchor).active = true
    dateEndChangeButtonTwo.topAnchor:constraintEqualToAnchor_constant_(endLabelResultTwo.bottomAnchor, 10).active = true
    citySaveButtonOne.topAnchor:constraintEqualToAnchor_(cityPickerOne.bottomAnchor).active = true
    citySaveButtonOne.trailingAnchor:constraintEqualToAnchor_(cityPickerOne.centerXAnchor).active = true
    citySaveButtonTwo.topAnchor:constraintEqualToAnchor_(cityPickerTwo.bottomAnchor).active = true
    citySaveButtonTwo.trailingAnchor:constraintEqualToAnchor_(cityPickerTwo.centerXAnchor).active = true
    dateStartSaveButtonOne.topAnchor:constraintEqualToAnchor_(dateStartPickerOne.bottomAnchor).active = true
    dateStartSaveButtonOne.trailingAnchor:constraintEqualToAnchor_(dateStartPickerOne.centerXAnchor).active = true
    dateEndSaveButtonOne.topAnchor:constraintEqualToAnchor_(dateEndPickerOne.bottomAnchor).active = true
    dateEndSaveButtonOne.trailingAnchor:constraintEqualToAnchor_(dateEndPickerOne.centerXAnchor).active = true
    dateStartSaveButtonTwo.topAnchor:constraintEqualToAnchor_(dateStartPickerTwo.bottomAnchor).active = true
    dateStartSaveButtonTwo.trailingAnchor:constraintEqualToAnchor_(dateStartPickerTwo.centerXAnchor).active = true
    dateEndSaveButtonTwo.topAnchor:constraintEqualToAnchor_(dateEndPickerTwo.bottomAnchor).active = true
    dateEndSaveButtonTwo.trailingAnchor:constraintEqualToAnchor_(dateEndPickerTwo.centerXAnchor).active = true
    cityCancelButtonOne.topAnchor:constraintEqualToAnchor_(cityPickerOne.bottomAnchor).active = true
    cityCancelButtonOne.leadingAnchor:constraintEqualToAnchor_(cityPickerOne.centerXAnchor).active = true 
    cityCancelButtonTwo.topAnchor:constraintEqualToAnchor_(cityPickerTwo.bottomAnchor).active = true
    cityCancelButtonTwo.leadingAnchor:constraintEqualToAnchor_(cityPickerTwo.centerXAnchor).active = true
    dateStartCancelButtonOne.topAnchor:constraintEqualToAnchor_(dateStartPickerOne.bottomAnchor).active = true
    dateStartCancelButtonOne.leadingAnchor:constraintEqualToAnchor_(dateStartPickerOne.centerXAnchor).active = true 
    dateEndCancelButtonOne.topAnchor:constraintEqualToAnchor_(dateEndPickerOne.bottomAnchor).active = true
    dateEndCancelButtonOne.leadingAnchor:constraintEqualToAnchor_(dateEndPickerOne.centerXAnchor).active = true
    dateStartCancelButtonTwo.topAnchor:constraintEqualToAnchor_(dateStartPickerTwo.bottomAnchor).active = true
    dateStartCancelButtonTwo.leadingAnchor:constraintEqualToAnchor_(dateStartPickerTwo.centerXAnchor).active = true 
    dateEndCancelButtonTwo.topAnchor:constraintEqualToAnchor_(dateEndPickerTwo.bottomAnchor).active = true
    dateEndCancelButtonTwo.leadingAnchor:constraintEqualToAnchor_(dateEndPickerTwo.centerXAnchor).active = true
    updateGraphButtonOne.topAnchor:constraintEqualToAnchor_constant_(startLabelResultOne.bottomAnchor, 200).active = true
    updateGraphButtonOne.leadingAnchor:constraintEqualToAnchor_(startLabelResultOne.leadingAnchor).active = true
    updateGraphButtonTwo.topAnchor:constraintEqualToAnchor_constant_(startLabelResultTwo.bottomAnchor, 200).active = true
    updateGraphButtonTwo.leadingAnchor:constraintEqualToAnchor_(startLabelResultTwo.leadingAnchor).active = true
    plot1 = nil
    plot2 = nil
    rectMode(CENTER)
    R = R() --sets instance of webR *note: can also add R commands as string as paramater to R()
    R.gfx:setFn(onRDraw,draw)
    --  CDC public databaste of wastewater SARS-CoV-2 levels (note: OData V4 JSON website not working so using Odata V2 XML site)
    URLBase = "https://data.cdc.gov/OData.svc/g653-rqe2" 
end

function updateGraphOne()
    local city = cityLabelResultOne.text
    local startDate = startLabelResultOne.text
    local endDate = endLabelResultOne.text
    if city == " set city " or startDate == " set start " or endDate == " set end " then
        return
    end
    local convertedCityElementForQuery = convertCityElementForQuery(1)
    local convertedStartDateForQuery = convertDateForQuery(startDate)
    local convertedEndDateForQuery = convertDateForQuery(endDate)
    queryAPIAndCalcPlot(city, convertedCityElementForQuery, convertedStartDateForQuery, convertedEndDateForQuery, 1)
end

function updateGraphTwo()
    local city = cityLabelResultTwo.text
    local startDate = startLabelResultTwo.text
    local endDate = endLabelResultTwo.text
    if city == " set city " or startDate == " set start " or endDate == " set end " then
        return
    end
    local convertedCityElementForQuery = convertCityElementForQuery(2)
    local convertedStartDateForQuery = convertDateForQuery(startDate)
    local convertedEndDateForQuery = convertDateForQuery(endDate)
    queryAPIAndCalcPlot(city, convertedCityElementForQuery, convertedStartDateForQuery, convertedEndDateForQuery, 2)
end

function convertCityElementForQuery(graphNumber)
    local convertedElement = ""
    if graphNumber == 1 then
        convertedElement = citySewershedCodeData[(cityPickerOne:selectedRowInComponent_(0))+1]
        return convertedElement
    else
        convertedElement = citySewershedCodeData[(cityPickerTwo:selectedRowInComponent_(0))+1]
        return convertedElement
    end
end

function convertDateForQuery(date)
    local m, d, y = string.match(date, "(%d+)/(%d+)/(%d+)")
    y = 2000 + y -- lua os.time function below needs year as 4 digits
    local dateTime = os.time({year=y, month=m, day=d})
    local convertedDate = os.date("%Y-%m-%d", dateTime)
    return convertedDate
end

function queryAPIAndCalcPlot(city,cityCode,startDate,endDate, graphNumber)
    -- turn off Update Graph buttons until finish updating the graph selected
    updateGraphButtonOne.enabled = false
    updateGraphButtonTwo.enabled = false
    query = "?$filter=date+ge+'"..startDate.."'+and+date+le+'"..endDate.."'+and+substringof('"..cityCode.."',key_plot_id)+eq+true&$select=date,pcr_conc_smoothed"
    http.request(URLBase..query, function(data, status, headers) tempResult = data end, function(error) print(error) end)
    -- add a Codea delay to ensure API data has fully downloaded 
    tween.delay(1.5, function() 
        tree = tree:new()
        local parser = xml2lua.parser(tree)
        parser:parse(tempResult)
        tempResult = nil
        local count = tonumber(tree.root.feed["m:count"])
        -- return from function if no data for dates requested
        if count == 0 then
            R('plot(1,1, type = "n", bty = "n", xaxt = "n", yaxt = "n", xlab = "", ylab = ""); text(1,1,"No Data"); Sys.sleep(0.4)')
            if graphNumber == 1 then
                plot1 = plot
            else
                plot2 = plot
            end
            updateGraphButtonOne.enabled = true
            updateGraphButtonTwo.enabled = true
            return
        end
        tempDataDate = {}
        tempDataVirus = {}
        for i = 1,count do
            -- make sure that another table is not stored at tag (CDC's XML website has some tables stored in pcr tags)
            if type(tree.root.feed.entry[i].content["m:properties"]["d:pcr_conc_smoothed"]) ~= "table" then
                table.insert(tempDataDate, tree.root.feed.entry[i].content["m:properties"]["d:date"])
                table.insert(tempDataVirus, tree.root.feed.entry[i].content["m:properties"]["d:pcr_conc_smoothed"])
            end
        end
        R.tempDataDate = tempDataDate
        R('date = as.Date(tempDataDate)')
        R.virusRNACopiesPerPersonInWastewater = tempDataVirus
        R.city = city
        R.count = count
        -- add a delay in R to ensure R finishes generating plot before Codea plots
        R('plot(date,virusRNACopiesPerPersonInWastewater, main=city, xaxt="n", sub=paste0("(n=",count,")")); axis.Date(1,date,format="%m-%d-%Y");Sys.sleep(0.4)')
        if graphNumber == 1 then
            plot1 = plot
        else
            plot2 = plot
        end
        updateGraphButtonOne.enabled = true
        updateGraphButtonTwo.enabled = true
    end)
    -- Note: CDC OData repository appears to allow downloads of 1000 entries at a time; thus, there may be some sites that
    --  have been collecting data daily since more standardized CDC reporting began 12/1/2021 that will need to add
    --  in code for additionally querying next pages of API data after 12/31/2024 
end

-- this function ensures that all objective-C subviews are removed if the user restarts the app
function willClose()
    titleLabel:removeFromSuperview()
    subtitleLabel:removeFromSuperview()
    cityLabelOne:removeFromSuperview()
    startLabelOne:removeFromSuperview()
    endLabelOne:removeFromSuperview()
    cityLabelTwo:removeFromSuperview()
    startLabelTwo:removeFromSuperview()
    endLabelTwo:removeFromSuperview()
    cityLabelResultOne:removeFromSuperview()
    startLabelResultOne:removeFromSuperview()
    endLabelResultOne:removeFromSuperview()
    cityLabelResultTwo:removeFromSuperview()
    startLabelResultTwo:removeFromSuperview()
    endLabelResultTwo:removeFromSuperview()
    dateStartPickerOne:removeFromSuperview()
    dateEndPickerOne:removeFromSuperview()
    dateStartPickerTwo:removeFromSuperview()
    dateEndPickerTwo:removeFromSuperview()
    cityPickerOne:removeFromSuperview()
    cityPickerTwo:removeFromSuperview()
    cityChangeButtonOne:removeFromSuperview()
    citySaveButtonOne:removeFromSuperview()
    cityCancelButtonOne:removeFromSuperview()
    cityChangeButtonTwo:removeFromSuperview()
    citySaveButtonTwo:removeFromSuperview()
    cityCancelButtonTwo:removeFromSuperview()
    dateStartChangeButtonOne:removeFromSuperview()
    dateStartSaveButtonOne:removeFromSuperview()
    dateStartCancelButtonOne:removeFromSuperview()
    dateEndChangeButtonOne:removeFromSuperview()
    dateEndSaveButtonOne:removeFromSuperview()
    dateEndCancelButtonOne:removeFromSuperview()
    dateStartChangeButtonTwo:removeFromSuperview()
    dateStartSaveButtonTwo:removeFromSuperview()
    dateStartCancelButtonTwo:removeFromSuperview()
    dateEndChangeButtonTwo:removeFromSuperview()
    dateEndSaveButtonTwo:removeFromSuperview()
    dateEndCancelButtonTwo:removeFromSuperview()
    updateGraphButtonOne:removeFromSuperview()
    updateGraphButtonTwo:removeFromSuperview()
end