-- Soda

viewer.mode = OVERLAY
viewer.mode = FULLSCREEN
-- Use this as a template for your projects that have Soda as a dependency. 

function setup()
    saveProjectInfo("Description", "Soda v"..Soda.version) 
    profiler.init()
    Soda.setup()
    parameter.watch("Soda.focus.title")
    overview{}
    -- demo1() --do your setting up here
end

function draw()
    --do your updating here
    pushMatrix()
    Soda.camera()
    drawing()
    popMatrix()
    profiler.draw()
end

function drawing(breakPoint) 
    --in order for gaussian blur to work, do all your drawing here
    background(40, 40, 50)
    sprite(asset.builtin.Cargo_Bot.Game_Area, WIDTH*0.5, HEIGHT*0.5, WIDTH, HEIGHT)
    Soda.draw(breakPoint)
end

--user inputs:

function touched(touch)
   if Soda.touched(touch) then return end
    --your touch code goes here
end

function keyboard(key)
    Soda.keyboard(key)
end

function sizeChanged(w, h)
    Soda.sizeChanged(w, h)
end

--measure performance:

profiler={}

function profiler.init(quiet)    
    profiler.del=0
    profiler.c=0
    profiler.fps=0
    profiler.mem=0
    if not quiet then
        parameter.watch("profiler.fps")
        parameter.watch("profiler.mem")
    end
end

function profiler.draw()
    profiler.del = profiler.del +  DeltaTime
    profiler.c = profiler.c + 1
    if profiler.c==10 then
        profiler.fps=profiler.c/profiler.del
        profiler.del=0
        profiler.c=0
        profiler.mem=collectgarbage("count", 2)
    end
end

