----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
UIKit = {}
UIView = class()
UIColorWell = class()
UIButton = class()
UILabel = class()
UITextField = class()
UITextView = class()

-- Aliases
UIColor = objc.UIColor
    
-- Monitor thread
-- Calls registered functions once per frame to identify
-- value changes in order to produce callbacks
local monitors = setmetatable({}, { __mode = "k" }) -- weak keys
local function registerMonitor(object, func)
    monitors[object] = func
end
Thread(function()
    while true do
        -- Call all of our monitors
        Thread.runOnMain(function()
            for _,monitor in pairs(monitors) do
                monitor()
            end
        end)
        Thread.yield()
    end
end)

UIKit.setup = Thread.wrapMain(function()
    assert(UIView.rootview == nil, "Only setup UIKit once!")
    
    for _,sv in ipairs(objc.viewer.view.subviews[1].subviews) do
        if tostring(sv) ~= "<KeyboardInputView>" then
            sv:removeFromSuperview()
        end
    end
    
    -- Our root UIView
    UIView.rootview = UIView(nil, objc.viewer.view.subviews[1])
end)

function UIView:init(frame, view)
    if not view then
        Thread.runOnMain(function()
            self.view = objc.UIView:alloc()
            self.view:initWithFrame_(frame or objc.viewer.view.frame)
        end)
    else
        self.view = view
    end
        
    -- Add subview array
    rawset(self, "subviews", {})
end

function UIView:addSubview(view)
     -- Track so it isn't garbage collected
    self.subviews[view] = view
    
    -- Track the superview
    rawset(view, "superview", self)
    
    -- Add the subview
    Thread.runOnMain(self.view.addSubview_, self.view, view.view)
end

function UIView:removeFromSuperview()
    -- Remove tracking reference
    self.superview.subviews[self] = nil
    
    -- Remove the subview
    Thread.runOnMain(self.view.removeFromSuperview, self.view)
end

-- All access passes through to the ObjC UIView
function UIView.__newindex(t, k, v)
    if k ~= "view" then
        Thread.runOnMain(function()
            t.view[k] = v
        end)
    else
        rawset(t, k, v)
    end
end

function UIColorWell:init(frame)
    assert(frame ~= nil)
    Thread.runOnMain(function()
        self.view = objc.UIColorWell:alloc()
        self.view:initWithFrame_(frame)
    end)
    
    -- Callback monitor
    local selected = color()
    registerMonitor(self, function()
        -- Only run if we have a callback to call
        if self.onChange then
            local c = self.view.selectedColor
            if c then
                local current = color(c.red, c.green, c.blue, c.alpha)
                -- Has the color changed?
                if current ~= selected then
                    selected = current
                    self.onChange(selected * 255) -- callback
                end
            end
        end
    end)
end

-- All access passes through to the ObjC UIView
function UIColorWell.__newindex(t, k, v)
    if k ~= "view" and k ~= "onChange" then
        Thread.runOnMain(function()
            t.view[k] = v
        end)
    else
        rawset(t, k, v)
    end
end

--- @class UIButton
-- Button UI object
UIButton.init = Thread.wrapMain(function(self, callback, buttonType)
    buttonType = buttonType or objc.enum.UIButtonType.roundedRect
    callback = Thread.callback(callback)
    local action = objc.UIAction:actionWithTitle_image_identifier_handler_(
        "",
        nil,
        nil,
        function(objAction)
            callback()
        end)
    self.view = objc.UIButton:buttonWithType_primaryAction_(buttonType, action)
end)

UIButton.setTitle = Thread.wrapMain(function(self, title)
    self.view:setTitle_forState_(title, objc.enum.UIControlState.normal)
end)

UIButton.setRadius = Thread.wrapMain(function(self, r)
    self.view.layer.cornerRadius = r
end)

-- All access passes through to the ObjC UIView
function UIButton.__newindex(t, k, v)
    if k ~= "view" then
        Thread.runOnMain(function()
            t.view[k] = v
        end)
    else
        rawset(t, k, v)
    end
end


UILabel.init = Thread.wrapMain(function(self, frame, label)
    self.view = objc.UILabel:alloc()
    self.view:initWithFrame_(frame or objc.viewer.view.frame)
    self.view.text = label
end)

-- All access passes through to the ObjC UIView
function UILabel.__newindex(t, k, v)
    if k ~= "view" then
        Thread.runOnMain(function()
            t.view[k] = v
        end)
    else
        rawset(t, k, v)
    end
end



UITextField.init = Thread.wrapMain(function(self, frame, text)
    self.view = objc.UITextField:alloc()
    self.view:initWithFrame_(frame or objc.viewer.view.frame)
    self.view.text = text
    
    local lastText = text
    registerMonitor(self, function()
        local cur = self.view.text
        if self.onEditCB and cur ~= lastText then
            self.onEditCB(cur)
        end
        lastText = cur
    end)
end)

function UITextField:onEdit(fn)
    rawset(self, "onEditCB", Thread.callback(fn))
end

-- All access passes through to the ObjC UIView
function UITextField.__newindex(t, k, v)
    if k ~= "view" then
        Thread.runOnMain(function()
            t.view[k] = v
        end)
    else
        rawset(t, k, v)
    end
end


UITextView.init = Thread.wrapMain(function(self, frame, text)
    self.view = objc.UITextView:alloc()
    self.view:initWithFrame_(frame or objc.viewer.view.frame)
    self.view.text = text
    
    local lastText = text
    registerMonitor(self, function()
        local cur = self.view.text
        if self.onEditCB and cur ~= lastText then
            self.onEditCB(cur)
        end
        lastText = cur
    end)
end)

function UITextView:onEdit(fn)
    rawset(self, "onEditCB", Thread.callback(fn))
end

-- All access passes through to the ObjC UIView
function UITextView.__newindex(t, k, v)
    if k ~= "view" then
        Thread.runOnMain(function()
            t.view[k] = v
        end)
    else
        rawset(t, k, v)
    end
end

UITextView.setRadius = Thread.wrapMain(function(self, r)
    self.view.layer.cornerRadius = r
end)

function UITextView:removeFromSuperview()
    -- Remove tracking reference
    self.superview.subviews[self] = nil
    
    -- Remove the subview
    Thread.runOnMain(self.view.removeFromSuperview, self.view)
end

-- Fonts
UIKit.families = {}
do
    for _,f in ipairs(objc.UIFont.familyNames) do
        local family = {}
        UIKit.families[f] = family
        for _,fnt in ipairs(objc.UIFont:fontNamesForFamilyName_(f)) do
            table.insert(family, fnt)
        end
    end
end

UIFont = Thread.wrapMain(function(name, size)
    return objc.UIFont:fontWithName_size_(name, size)
end)
