----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------

-- Refs for non-transferable objects
local refs = {}
local refId = 0

local local_io = {
    open = function(...)
        local h = io.open(...)
        if h == nil then return nil end
        refId = refId + 1
        refs[refId] = h
        return refId
    end,
    close = function(ref)
        refs[ref[1]]:close()
    end,
    write = function(ref, data)
        for _,v in ipairs(data) do
            refs[ref[1]]:write(string.pack("B", v))
        end
    end
}

local local_os = {
    tmpname = function()
        return asset.path .. "/" .. os.tmpname():match("[^/]*$")
    end
}

local local_webrepo = {
    install = function(path, name, version)
        
        -- Create project (if it doesn't already exist)
        if not hasProject(name) then
            createProject(name)
        else
            -- Erase previous project
            if project_name == "WebRepoExperimental" then
                -- Currently running project
                local files = asset.all
                for _,file in pairs(files) do
                    if file.path ~= path then
                        os.remove(file.path)
                    end
                end
            else
                deleteProject(name)
                createProject(name)
            end
        end
        
        local luaFiles = {}
        
        local zip = Zip(path)
        local files = zip:listFiles()
        for _,path in ipairs(files) do
            local file_data = zip:readFile(path)
            if path:find("/.-/") then -- 2 slashes (subfolder)
                local sf = asset.documents.path .. "/" .. path:gsub("/[^/]-$", "")
                    
                local fm = objc.NSFileManager.defaultManager
                if not fm:fileExistsAtPath_isDirectory_(sf, true) then
                    fm:createDirectoryAtPath_withIntermediateDirectories_attributes_error_(sf, true, nil, nil)
                end
            end
            local file = io.open((asset.documents .. path).path, "wb")
            file:write(file_data)
            file:close()
            
            -- Track lua files that are in this version
            if path:match(".-%.lua$") then
                luaFiles[path:match("/(.-)%.lua$")] = true
            end
        end
        
        -- Delete zip file
        os.remove(path)
        
        -- Add webrepo version file
        local file = io.open((asset.documents .. name .. ".codea/webrepo_version").path, "w")
        file:write(version)
        file:close()
    
        -- Unsplit split files
        unsplitProject(asset.documents[name .. ".codea"])
    end
}

WebRepoClient = class()
function WebRepoClient:init()
    -- Load page into WKWebview
    self.wv = WebView("https://" .. WRL.Host .. "/WebRepo/client")
    self.wv:show()
    
    -- Add some message handlers
    local handlers = self.wv.handlers
    
    -- Add handler tables
    handlers.io = local_io
    handlers.os = local_os
    handlers.webrepo = local_webrepo
    
    -- Send a close signal to the JS to ensure
    -- it can shutdown correctly (IndexedDB...)
    table.insert(willClosehandlers, function()
        self.wv:willClose()
    end)
end

function WebRepoClient:update()
    -- Detect frame changes
    self.wv:updateFrame()
end
