----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------

function WebViewMessageHandlers(controller, webview)
    local handlerFns = {}
    
    do -- Add our message handler
        local Handler = objc.delegate("WKScriptMessageHandler")
        function Handler:userContentController_didReceiveScriptMessage_(objUserContentController, objMessage)
            local msg = objMessage.body
            
            -- Access using '.' separators
            local handler = handlerFns
            for part in msg.fn:gmatch("[^%.]*") do
                handler = handler[part]
            end
            
            assert(handler ~= nil, "Unregistered function: " .. msg.fn)
            local results = table.pack(handler(table.unpack(msg.args, 1, msg.nArgs)))
                
            -- Convert integer keys to strings
            for k,v in pairs(results) do
                if type(k) == "number" then
                    results[tostring(k-1)] = v
                end
            end
            
            -- Return result to JS
            webview:callAsyncJavaScript_arguments_inFrame_inContentWorld_completionHandler_(
                "window.codea.resolveCall(id, result);",
                {
                    result = results,
                    id = msg.id
                },
                nil,
                objc.WKContentWorld.pageWorld,
                nil
            )
        end
        local h = Handler()
        controller:addScriptMessageHandler_contentWorld_name_(h, objc.WKContentWorld.pageWorld, "codea")
    end
    
    -- Add some defaults
    handlerFns.print = print
    handlerFns.warn = objc.warning
    handlerFns.error = error
    
    return handlerFns;
end

WebView = class()
function WebView:init(url)
    -- Create the WKWebView
    self.view = objc.WKWebView:alloc()
    
    -- Add Codea message handler
    local controller = objc.WKUserContentController()
    self.handlers = WebViewMessageHandlers(controller, self.view)
        
    -- Create the WebView config
    local config = objc.WKWebViewConfiguration()
    config.userContentController = controller

    -- Initialise the WKWebView
    self.view:initWithFrame_configuration_(objc.viewer.view.bounds, config)
    
    -- Avoid white flash
    --self.view.opaque = false
    --self.view.backgroundColor = objc.UIColor.grayColor
    
    -- Ignore safe areas
    self.view.scrollView.contentInsetAdjustmentBehavior = 2;
    
    -- Load the WebRepo client
    local url = objc.NSURL:URLWithString_(url)
    local request = objc.NSURLRequest:requestWithURL_(url)
    self.view:loadRequest_(request)
		
    -- Wait for the view to load
    while self.view.isLoading do end
end

function WebView:exec(code, args)
	self.view:callAsyncJavaScript_arguments_inFrame_inContentWorld_completionHandler_(
		code,
		args or {},
		nil,
		objc.WKContentWorld.pageWorld,
		nil
	)
end

--- Display the content of the WebView.
--
-- This places our WKWebView over Codea's OpenGL based EAGLView
function WebView:show()        
    -- Place the WKWebView over the EAGLView
    objc.viewer.view:insertSubview_atIndex_(self.view, 1)
end

function WebView:updateFrame()
    self.view.frame = objc.viewer.view.bounds
end

function WebView:willClose()
    self.view:removeFromSuperview()
    self:exec("willClose();")
end
