----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------

local button_style_sheet = {
    radius = 6,
    fill = color(0, 0),
    fillButtonNormal = color(0, 0),
    fillButtonHover = color(96, 168, 230),
    fillButtonPressed = color(0, 126, 255)
}

-- Current tab
local current_tab = "Today"

local function button(icon, label, callback)
    local node = Oil.Node(0, -5, 60, 75)
        :add_renderer(Oil.RectRenderer)
        :set_style_sheet(button_style_sheet)
        :add_updater(function(node)
            -- Ensure we remain 'pressed' if this is the selected tab
            if current_tab == label then
                node:set_style("fill", node:get_style("fillButtonPressed"))
            end
        end)
        :add_handler(Oil.ButtonHandler(function(bttn)
            callback(bttn, label)
        end))
        :add_children(
            Oil.Label(0, -5, 1.0, 40, icon):set_style("fontSize", 40),
            Oil.Label(0, -50, 1.0, 20, label)
        )
    
    return node
end

function CreateTabRow(news_node, games_node, apps_node, libs_node, --[[assets_node,]] search_node)
    
    -- Track the nodes we're controlling
    local nodes = {}
    nodes["Today"] = news_node
    nodes["Games"] = games_node
    nodes["Apps"] = apps_node
    nodes["Libs"] = libs_node
    --nodes["Assets"] = assets_node
    nodes["Search"] = search_node
    
    local anim_ids = {}
    anim_ids["Today"] = 1
    anim_ids["Games"] = 2
    anim_ids["Apps"] = 3
    anim_ids["Libs"] = 4
    anim_ids["Assets"] = 5
    anim_ids["Search"] = 6
    
    local function callback(bttn, id)
        if id == current_tab then
            return
        end
        
        -- Hide all nodes first
        for _,v in pairs(nodes) do
            v.enabled = false
        end
        
        -- Enable old and new tabs
        nodes[current_tab].enabled = true
        nodes[id].enabled = true
        
        if anim_ids[current_tab] < anim_ids[id] then
            -- Move old tab offscreen
            local old_node = nodes[current_tab]
            tween(0.25, old_node, {
                x = -WIDTH
            }, nil, function()
                old_node.enabled = false
            end) 
            
            -- Move new tab on screen
            local node = nodes[id]
            node.x = WIDTH
            tween(0.25, node, {
                x = 1
            }, nil, function()
                node.x = 0
            end)
        else
            -- Move old tab offscreen
            local old_node = nodes[current_tab]
            tween(0.25, old_node, {
                x = WIDTH
            }, nil, function()
                old_node.enabled = false
            end) 
            
            -- Move new tab on screen
            local node = nodes[id]
            node.x = -WIDTH
            tween(0.25, node, {
                x = 0
            })
        end
            
        -- Update current tab
        current_tab = id
        
        -- Disable all button backgrounds for now
        -- (the button updaters will correct this)
        for _,bttn in pairs(bttn.parent.children) do
            bttn:set_style("fill", bttn:get_style("fillButtonNormal"))
        end
    end
    
    Oil.Rect(0, 0, 1.0, 80 + layout.safeArea.bottom)
    :set_style_sheet(UI.THEME.tab_bar)
    :add_child(
        Oil.HorizontalStack(0, 0, 1.0, 80 + layout.safeArea.bottom)
        :add_renderer(Oil.RectRenderer)
        :add_style("fill", color(255))
        :add_style("blur", true)
        :add_style("blur_amount", 2.0)
        :add_style("blur_kernel_size", 32)
        :add_children(
            button("📅", "Today", callback),
            button("🎮", "Games", callback),
            button("🛠", "Apps", callback),
            button("📚", "Libs", callback),
            --button("🎨", "Assets", callback),
            button("🔍", "Search", callback)
        )
    )
    
    -- Disable all but News
    for _,v in pairs(nodes) do
        v.enabled = false
    end
    nodes["Today"].enabled = true
end
