----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
-- WebRepoSub

-- TODO:
-- Dynamic texture loading to reduce memory usage - NEXT
-- One line text entry
-- Asset bundles
-- Multi project bundles
-- Username validation via discourse API (https://talk.codea.io/u/<username>.json)
-- (DONE) Metadata review
-- (DONE) Search tab
-- (DONE) Auto-update
-- (DONE) Remove old projects from repo
-- (DONE) Check flow of private keys/passwords
-- (DONE) iPhone & iPad specific projects
-- (DONE) Tab animations
-- (DONE) Handle submissions with dependencies
-- (DONE) Oil scroll nested clipping
-- (DONE) Fix buttons on news & app lists
-- (DONE) Settings screenr
-- (DONE) Approval timestamps (github end)
-- (DONE) Admin submissions
-- (DONE) Project sizes
-- (DONE) Forum-links
-- (DONE) Remove .version during submission
-- (DONE) What's New strings

WRL.Trace.ConfigureChannel("info", true, false)
WRL.Trace.ConfigureChannel("downloads", true, false)
WRL.Trace.ConfigureChannel("db", true, false)

function setup()
    
    if WRL.Version and WRL.Version >= 2 then
        WRL.Trace("info")
    end
    
    viewer.mode = FULLSCREEN_NO_BUTTONS
    viewer.preferredFPS = 60
    
    -- Ensure all URL requests are uncached
    objc.NSURLCache.sharedURLCache:removeAllCachedResponses()
    
    Oil.setup()
    DB.setup()
    
    Oil.root:add_renderer(Oil.RectRenderer)
        :set_style(UI.THEME.background)
    
    -- Top right buttons
    do  
        local node = Oil.HorizontalStack(-10, -(0.0001 + layout.safeArea.top), 1.0, 50)
        :set_priority(10)
        :add_style("align", RIGHT)
        
        -- Add review button
        UI.REVIEW_BUTTON = Oil.TextButton(0, 0.5, 80, 30, "Review", function()
            ReviewWindow()
        end)
        :set_style_sheet(UI.THEME.button)
        
        -- Allow it to be disabled
        UI.REVIEW_BUTTON.enabled = UI.ENABLE_REVIEW

        node:add_child(UI.REVIEW_BUTTON)
        
        -- Add other buttons
        node:add_children(
            Oil.TextButton(0, 0.5, 80, 30, "Submit", function()
                SubmitWindow()
            end)
            :set_style_sheet(UI.THEME.button),
        
            Oil.TextButton(0, 0.5, 80, 30, "Settings", function()
                SettingsWindow()
            end)
            :set_style_sheet(UI.THEME.button)
        )
    end
    
    -- Top left buttons
    Oil.HorizontalStack(10, -(0.0001 + layout.safeArea.top), 1.0, 50)
    :set_priority(10)
    :add_style("align", LEFT)
    :add_children(
        Oil.EmojiButton(0, 0.5, 30, 30, "❌", function()
            viewer.close()
        end)
        :set_style_sheet(UI.THEME.button)
        :add_style("fontSize", 14)
        :add_style("textFill", color(255))
    )
    
    -- Bottom bar
    local news = Oil.Node(0, 0, 1.0, 1.0)
    local games = AppList()
    local apps = AppList()
    local libs = AppList()
    --local assets = AppList()
    local search = AppList(true) -- enable search
    CreateTabRow(news, games, apps, libs, --[[assets,]] search)
    
    -- Initialise tabs
    initNewsNode(news)
    news.hidden = true
    
    local onLoadStore = function(store)
        if store then
            local wrApp = DB.getLatestApp("WebRepo")
            if DB.isAppInstalled("WebRepo", wrApp.version) == false then
                local alert = Oil.Rect(0, 0, 1.0, 1.0)
                :set_priority(100) -- over everything
                :add_style("fill", color(0, 128)) --darken the background
                
                local function doUpdate()
                    -- Remove buttons
                    alert.children[1].children[2]:kill()
                    alert.children[1].children[2]:kill()
                    
                    local label = alert.children[1].children[1]
                    label:add_style("text", "Downloading update")
                    
                    DB.downloadApp(wrApp, function(success, err)
                        if success then
                            Thread(function()
                                label:add_style("text", "Installing update")
                                DB.installApp(wrApp.name, wrApp.version)
                                label:add_style("text", "Update complete.\nPlease relaunch WebRepo.")
                                alert.children[1]:add_child(
                                    Oil.TextButton(0.5, 20, 177.5, 40, "Restart", function() viewer.close() end)
                                    :set_style_sheet(UI.THEME.button)
                                )
                            end)
                        else
                            print(err)
                            label:add_style("text", "Download failed\n" .. err)
                        end
                    end, function(progress)
                        label:add_style("text", "Downloading (" .. tostring(math.ceil(progress * 100)) .. "%)")
                    end)
                end
    
                alert:add_child(
                    Oil.Rect(0.5, 0.5, 370, 300)
                    :set_style_sheet(UI.THEME.alert)
                    :add_handler(function(node, event)
                        return true
                    end)
                    :add_children(
                        Oil.Label(5, 50, 360, 245, "A WebRepo update is available.\nNew features may need this update.\n\nUpdate now?")
                        :add_style("textWrapWidth", 360)
                        :set_style_sheet(UI.THEME.alert),
    
                        Oil.TextButton(20, 20, 177.5, 40, "Update Later", function() alert:kill() end)
                        :set_style_sheet(UI.THEME.button),
    
                        Oil.TextButton(-20, 20, 177.5, 40, "Update Now", function() doUpdate() end)
                        :set_style_sheet(UI.THEME.button)
                    )
                )
            end
            
            Thread(function()
                -- Presort the apps so the async load isn't quite so chaotic
                local sortedApps = {}
                for name,versions in pairs(store) do
                    -- Only use the latest version
                    local app = store[name][#versions]
                    table.insert(sortedApps, { app, #versions == 1 })
                end
                table.sort(sortedApps, function(a, b)
                    local ap = 33166368000 - (a[1].info.timestamp or 1)
                    local bp = 33166368000 - (b[1].info.timestamp or 1)
                    return ap < bp
                end)
                
                -- Load the apps into their screens one per-frame
                for _,app in ipairs(sortedApps) do
                    local numversions = app[2]
                    local app = app[1]
                    
                    newsAddItem({
                        type = (numversions == 1 and "new_project") or "new_update",
                        app = app
                    })
                    
                    if app.info.category == "App" then
                        apps:add_app(app)
                    elseif app.info.category == "Game" then
                        games:add_app(app)
                    elseif app.info.category == "Library" then
                        libs:add_app(app)
                    elseif app.info.category == "Assets" then
                        --assets:add_app(app)
                        libs:add_app(app)
                    end
                    
                    search:add_app(app)
                    Thread.yield()
                end
            end)
        else
            print("Failed to load store")
        end
        news.hidden = false
    end
    
    -- Initialise the backend
    DB.loadStore(onLoadStore)
end

function draw()
    collectgarbage("collect")
    
    Oil.beginDraw()
    Oil.endDraw()
end

function sizeChanged(w, h)
    Oil.sizeChanged(w, h)
end

function hover(g)
    Oil.hover(g)
end

function scroll(g)
    Oil.scroll(g)
end

function touched(t)
    Oil.touch(t)
end

function keyboard(k)
    Oil.keyboard(k)
end
