----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
local splitSize = 25 * 1024 * 1024;
    
function splitProject(project)
    local splits = {}
    local remove = {}
    local count = 1
    
    -- Unsplit and the re-split if we've already split before
    -- this is incase something has changed
    for _,file in ipairs(project.all) do
        if file.name == "_wrsplit_manifest.txt" then
            unsplitProject(project)
            break
        end
    end
    
    local function split(f, s, size)
        while size > 0 do
            local readSize = math.min(splitSize, size)
            
            local d = f:read(readSize)
            saveText(project .. ("_wrsplit_" .. count), d)
            
            table.insert(s, count)
            count = count + 1
            size = size - readSize
        end
    end
    
    local function splitFolder(folder) 
        local files = folder.all
        for _,file in ipairs(files) do
            if file.type == "folder" then
                splitFolder(file)
            else
                --print(file.path)
                local f = io.open(file.path, "rb")
                f:seek("end")
                local filesize = f:seek()
                -- Split the file into 25MB chunks
                if filesize > 25 * 1024 * 1024 then
                    f:seek("set", 0)
                    local s = {}
                    
                    local sub = project.path:gsub("%.", "%%.") .. "/"
                    sub = sub:gsub("%-", "%%-")
                    splits[file.path:gsub(sub, "")] = s
                    split(f, s, filesize)
                    f:close()
                    table.insert(remove, file)
                else
				        f:close()
                end
            end
        end
    end
    
    splitFolder(project)
    
    if count > 1 then
        -- Write split manifest
        saveText(project .. "_wrsplit_manifest.txt", json.encode(splits))
        
        -- Delete the files we've just split
        for _,file in ipairs(remove) do
            os.remove(file.path)
        end
    end
end

function unsplitProject(project)
    -- Read split manifest
    local man = readText(project .. "/_wrsplit_manifest.txt")
    if man then
        local splits = json.decode(man)
        
        -- Merge the split files back into their original files
        for path, s in pairs(splits) do
            local f = io.open(project.path .. "/" .. path, "wb")
            
            for _,v in ipairs(s) do
                -- Read the split file
                local fs = io.open(project.path .. "/_wrsplit_" .. v .. ".txt", "rb")
                local data = fs:read("*a")
                fs:close()
                
                -- Write split data to original file
                f:write(data)
                
                -- Delete split file
                os.remove(project.path .. "/_wrsplit_" .. v .. ".txt")
            end
            
            f:close()
        end
        
        -- Delete split manifest
        os.remove(project.path .. "/_wrsplit_manifest.txt")
    end
end
