
-- microphone information

viewer.mode=FULLSCREEN

function setup()   
    mic.start()
    fill(255)
    viewer.retainedBacking=true
    x,xh=-1,0
    ah,fh=HEIGHT/2+100,0
    strokeWidth(2)
end

function draw()
    if x<1 then
        background(32, 96, 74)
    end
    hz()
    amp=mic.amplitude
    a=amp*2000+HEIGHT/2
    freq=mic.frequency
    f=freq/10+100
    stroke(255)
    line(xh,ah,x,a)
    line(0,HEIGHT/2,WIDTH,HEIGHT/2)
    stroke(255,0,0)
    line(xh,fh,x,f)
    line(0,100,WIDTH,100)  
    xh=x
    ah=a
    fh=f
    x=x+1
    if x>WIDTH then
        x=0
        xh=0
    end
    text("Microphone information",WIDTH/2,HEIGHT-100)
    text("amplitude (volumn)",WIDTH/2,HEIGHT/2-30)
    text("frequency (pitch)",WIDTH/2,70)
end

function hz()
    ellipse(WIDTH/2,140,5)
    text("440hz",WIDTH/2,120)  
end
