
-- moon

viewer.mode=FULLSCREEN

function setup()
    col={color(255,0,0),color(255,255,0),color(0,255,0),color(0, 255, 138),
            color(255,255,255),color(255,0,255)}
    str="Reading moon image, please wait."          
    moonImage=readImage(asset.."moon1")
    if moonImage==nil then
        url="http://lroc.sese.asu.edu/news/uploads/lroc_wac_nearside_noslew.png"
        http.request(url,goodResponse,badResponse)
    end
    tab={}
    moonTab=
    {   
        -- mountains
        {x=13,y=286,n="Alpine Valley",c=1},
        {x=2,y=289,n="Alps Mts",c=1},
        {x=143,y=-164,n="Altai Scarp",c=1},
        {x=-15,y=124,n="Apennine Mts",c=1},
        {x=-160,y=99,n="Carpathian Mts",c=1},
        {x=48,y=219,n="Caucasus Mts",c=1},
        {x=80,y=118,n="Haemus Mts",c=1},
        {x=-157,y=277,n="Jura Mts",c=1},
        {x=244,y=-83,n="Pyrenees Mts",c=1},
        {x=179,y=-239,n="Rheita Mts",c=1},
        {x=-172,y=-48,n="Riphaeus Mts",c=1},
        {x=-28,y=215,n="Spitzbergen",c=1},
        {x=-87,y=283,n="Straight Range",c=1},
        {x=-47,y=-143,n="Straight Wall",c=1},      
        {x=203,y=190,n="Taurus Mts",c=1},
        {x=-59,y=280,n="Teneriffe Mts",c=1},
    
        -- plain
        {x=-50,y=75,n="Sinus Aestuum",c=2}, 
        {x=-139,y=264,n="Sinus Iridum",c=2}, 
        {x=-2,y=3,n="Sinus Medii",c=2}, 
        {x=-250,y=215,n="Sinus Roris",c=2}, 
    
        -- lake
        {x=144,y=235,n="Lacus Somniorum",c=3},  
      
        -- ocean
        {x=-283,y=56,n="Oceanus Procellarum",c=4},  
        
        -- mare
        {x=307,y=113,n="Mare Crisium",c=5},
        {x=286,y=-7,n="Mare Foecunditatis",c=5},
        {x=102,y=308,n="Mare Frigoris",c=5},
        {x=-224,y=-151,n="Mare Humorum",c=5},
        {x=-91,y=203,n="Mare Imbrium",c=5},
        {x=203,y=-100,n="Mare Nectaris",c=5},
        {x=-93,y=-133,n="Mare Nubium",c=5},
        {x=109,y=170,n="Mare Serenitatis",c=5},
        {x=180,y=53,n="Mare Tranquillitatis",c=5},
        {x=21,y=90,n="Mare Vaporum",c=5},

        -- craters
        {x=26,y=-76,n="Albategnius",c=6},
        {x=-18,y=-88,n="Alphonsus",c=6},
        {x=139,y=41,n="Arago",c=6},
        {x=-23,y=188,n="Archimedes",c=6},
        {x=-257,y=153,n="Aristarchus",c=6},
        {x=6,y=211,n="Aristillus",c=6},
        {x=72,y=292,n="Aristoteles",c=6},
        {x=-13,y=-120,n="Arzachel",c=6},
        {x=181,y=276,n="Atlas",c=6},
        {x=8,y=194,n="Autolycus",c=6},
        {x=109,y=141,n="Bessel",c=6},
        {x=-135,y=-135,n="Bullialdus",c=6},
        {x=32,y=229,n="Cassini",c=6},
        {x=145,y=-119,n="Catharina",c=6},
        {x=-52,y=-327,n="Clavius",c=6},
        {x=279,y=177,n="Cleomedes",c=6},
        {x=263,y=-102,n="Cook",c=6},
        {x=-128,y=64,n="Copernicus",c=6},
        {x=152,y=-87,n="Cryillus",c=6},
        {x=114,y=-13,n="Delambre",c=6},
        {x=187,y=306,n="Endymion",c=6},
        {x=-73,y=94,n="Eratosthenes",c=6},
        {x=76,y=265,n="Eudoxus",c=6},
        {x=194,y=-139,n="Fracastorius",c=6},
        {x=270,y=-222,n="Furnerius",c=6},    
        {x=-232,y=-114,n="Gassendi",c=6},
        {x=-366,y=-21,n="Grimaldi",c=6},
        {x=37,y=-53,n="Halley",c=6},
        {x=164,y=276,n="Hercules",c=6},
        {x=-14,y=-37,n="Herschel",c=6},
        {x=-349,y=14,n="Hevelius",c=6},
        {x=32,y=-36,n="Hipparchus",c=6},
        {x=98,y=58,n="Julius Caesar",c=6},
        {x=-232,y=53,n="Kepler",c=6},
        {x=-170,y=-3,n="Landsberg C",c=6},
        {x=329,y=-58,n="Langrenus",c=6},
        {x=-90,y=-290,n="Longomontanus",c=6},
        {x=254,y=137,n="Macrobius",c=6},
        {x=-25,y=-291,n="Maginus",c=6},
        {x=57,y=94,n="Manilius",c=6},
        {x=190,y=14,n="Maskelyne",c=6},
        {x=68,y=-255,n="Maurolycus",c=6},
        {x=-268,y=-140,n="Mersenius",c=6},
        {x=227,y=187,n="Newcomb",c=6},
        {x=299,y=-163,n="Petavius",c=6},
        {x=176,y=-189,n="Piccolomini",c=6},
        {x=-38,y=298,n="Plato",c=6},
        {x=146,y=100,n="Plinius",c=6},
        {x=161,y=201,n="Posidonius",c=6},
        {x=-12,y=-61,n="Ptolemaeus",c=6},
        {x=-148,y=21,n="Reinhold",c=6},
        {x=137,y=77,n="Ross",c=6},
        {x=-223,y=-265,n="Schickard",c=6},
        {x=-150,y=-300,n="Schiller",c=6},
        {x=273,y=-187,n="Snellius",c=6},
        {x=260,y=-205,n="Stevinus",c=6},
        {x=274,y=36,n="Taruntius",c=6},
        {x=166,y=-77,n="Theophilus",c=6},
        {x=-77,y=170,n="Timocharis",c=6},
        {x=-54,y=-261,n="Tycho",c=6},
        {x=321,y=-107,n="Vendelinus",c=6},
        {x=-99,y=-259,n="Wilhelm",c=6},
    }
    size=760
    d1,d2=0,0
    dx,dy=WIDTH/2,HEIGHT/2
    cx,cy=dx,dy  
    pct=size/760  
    show=true
end

function goodResponse(picture,status,headers)
    moonImage=picture
    saveImage(asset.."moon1",moonImage)
end

function badResponse(picture,status,headers)
    str="Error reading moon image file."
end

function draw()
    background(0)
    if moonImage==nil then
        fill(255)
        text(str,WIDTH/2,HEIGHT/2)
        return
    end
    sprite(moonImage,dx,dy,size)
    dfx=(cx-dx)/pct
    dfy=(cy-dy)/pct
    if show then
        stroke(255)
        strokeWidth(1)
        noFill()
        ellipse(WIDTH/2,HEIGHT/2,20)
        fill(255)
        for a,b in pairs(moonTab) do
            if dfx>b.x-3 and dfx<b.x+3 and dfy>b.y-3 and dfy<b.y+3 then
                text(b.n,WIDTH/2,HEIGHT/2+30)
                break
            end
        end
        text(((cx-dx)/pct//1).."  "..((cy-dy)/pct//1),WIDTH/2,HEIGHT-40)
        noStroke()
        for a,b in pairs(moonTab) do
            fill(col[b.c])
            ellipse(dx+b.x*pct,dy+b.y*pct,5)
        end        
    end
end

function touched(t)
    if t.state==BEGAN then
        if t.tapCount==3 then   -- 3 taps turns points on / off
            show=not show
            return
        end
        d1,d2=0,0
        table.insert(tab,vec3(t.x,t.y,t.id))
    end
    if t.state==MOVING then -- shrink or enlarge moon image
        if #tab == 2 then
            for z=1,2 do
                if t.id==tab[z].z then
                    tab[z].x=t.x
                    tab[z].y=t.y
                end
            end
            d1=math.sqrt((tab[1].x-tab[2].x)^2+(tab[1].y-tab[2].y)^2)
            if d2==0 then
                d2=d1           
            end
            size=size+(d1-d2)*3
            if size<760 then    -- dont allow moon to go smaller than this
                size=760
            end
            d2=d1
        else
            dx=dx+t.deltaX
            dy=dy+t.deltaY
        end
    end        
    if t.state==ENDED then  -- clear tab of ended touch id
        for z=1,#tab do
            if t.id==tab[z].z then
                table.remove(tab,z)
                return
            end
        end
    end 
    pct=size/760    -- recalculate size percent
end 
