-- checkerboard puzzle

viewer.mode=FULLSCREEN

function setup()
    fitcount,trycount,solution,nextopen=0,0,0,0
    pieceoffset,size=1,40
    w1,stop=true,true
    fill(255)
    
    -- color of each piece
    col={color(255,0,0),color(0,255,0),color(0,0,255),
        color(255,255,0),color(0,255,255),color(255,0,255),
        color(255,64,0),color(255,128,128),color(128,128,255),
        color(128,128,128),color(128,64,64),color(255,0,128)}
     
    -- position of pieces on the right side of the board   
    show={vec2(500,900),vec2(500,780),vec2(500,700),vec2(500,580),
          vec2(530,480),vec2(530,380),vec2(650,900),vec2(650,800),
          vec2(650,700),vec2(650,600),vec2(650,500),vec2(650,380)}
    
    used={0,0,0,0,0,0,0,0,0,0,0,0}  -- table of used pieces
    rot={0,0,0,0,0,0,0,0,0,0,0,0}   -- rotation table. 1=normal 2,3,4=rotation
    here={0,0,0,0,0,0,0,0,0,0,0,0}  -- starting position of each used piece ??
    
    -- checkerboard with a border on each side
    board={ 88,88,88,88,88,88,88,88,88,88,
            88,00,00,00,00,00,00,00,00,88,
            88,00,00,00,00,00,00,00,00,88,
            88,00,00,00,00,00,00,00,00,88,
            88,00,00,00,00,00,00,00,00,88,
            88,00,00,00,00,00,00,00,00,88,
            88,00,00,00,00,00,00,00,00,88,
            88,00,00,00,00,00,00,00,00,88,
            88,00,00,00,00,00,00,00,00,88,
            88,88,88,88,88,88,88,88,88,88}
    
    piece={ --table of 12 pieces, each piece rotated 90 degrees counter clockwise
        --1 
        {{0,1,2,3,10,11},{0,10,20,21,30,31},{0,1,8,9,10,11},{0,1,10,11,21,31}},
        --2   
        {{0,1,2,3,4,12},{0,10,20,21,30,40},{0,8,9,10,11,12},{0,10,19,20,30,40}},
        --3    
        {{0,1,2,12},{0,1,10,20},{0,10,11,12},{0,10,19,20}}, 
        --4       
        {{0,1,2,3,4,5,15},{0,1,10,20,30,40,50},{0,10,11,12,13,14,15},{0,10,20,30,40,49,50}},  
        --5    
        {{0,1,10,11,21},{0,1,2,10,11},{0,10,11,20,21},{0,1,9,10,11}},  
        --6     
        {{0,1,2,3,11,12},{0,10,11,20,21,30},{0,1,9,10,11,12},{0,9,10,19,20,30}},
        --7    
        {{0,10,20,21},{0,8,9,10},{0,1,11,21},{0,1,2,10}},
        --8    
        {{0,1,2,11,12,22,32},{0,1,2,3,10,11,20},{0,10,20,21,30,31,32},{0,9,10,17,18,19,20}},
        --9    
        {{0,1,10,11,20},{0,1,10,11,12,},{0,9,10,19,20},{0,1,2,11,12}},
        --10    
        {{0,10,11,21,31},{0,1,2,9,10},{0,10,20,21,31},{0,1,8,9,10}},
        --11    
        {{0,1,2,11},{0,10,11,20},{0,9,10,11},{0,9,10,20}},
        --12    
        {{0,1,2,3,11},{0,10,20,21,30},{0,8,9,10,11},{0,9,10,20,30}}}   
end

function draw()
    background(136, 206, 224)
    text("Tap screen to run",WIDTH-150,HEIGHT-225)
    button()
    drawboard()
    showTotals()
    showPieces()
    solve()
end

function solve()
    if singleStep then
        if ss then
            return
        end
        ss=true
    end
    if stop or wait then
        return
    end
    if w1 then
        nextopen=nextboardPosition()
        nextpiece(pieceoffset,1)
        w1,yy=false,true
    end
    while yy==true do
        nextopen=nextboardPosition()
        if checkfit()==1 then
            pieceoffset=pieceoffset+1
            if pieceoffset>12 then
                pieceoffset=12
                solution=solution+1                
                wait=true
                printSolution()
                return
            else
                yy=false
            end
        else
            addone()
        end
    end
    w1=true
end

function touched(t)
    if t.state==BEGAN then
        if t.x>WIDTH-200 and t.x<WIDTH-100 and 
                t.y>HEIGHT-200 and t.y<HEIGHT-150 then
            singleStep=true
            ss=false
            stop=false
            return
        end
        singleStep,ss=false,false
        if wait then
            wait=false
            removepiece()
            addone()
            return
        end
        stop=false
    end
end

function button()
    fill(255)
    rect(WIDTH-200,HEIGHT-200,100,50)
    fill(0)
    text("Single Step",WIDTH-150,HEIGHT-175)   
end

function drawboard()
    pushStyle()
    local z,c=0,0
    for y=10,1,-1 do
        for x=1,10 do
            z=z+1
            c=board[z]
            if c==0 then
                fill(0)
            elseif c==88 then
                fill(110)
            else
                fill(col[c])
            end
            rect(30+x*size,360+y*size,size,size)
            fill(0)
            if c>0 and c<13 then
                text(c,30+x*size+size/2,360+y*size+size/3)  
            end          
        end
    end
    popStyle()
end

function showPieces()
    pushStyle()
    rectMode(CENTER)
    fontSize(10)
    local rr=rect local tt=text local pp=piece local v=0
    local tab={0,0,0,0,0,0,0,0,0,0,0,0}
    for z=1,12 do
        v=used[z]
        if v>0 then
            tab[v]=1          
        else
            tab[v]=0
        end
    end
    for z=1,#show do
        for w=1,#pp[z][1] do
            fill(col[z])
            if tab[z]>0 then
                fill(255)
            end
            v=pp[z][1][w]
            rr(show[z].x+(v%10)*20,show[z].y-(v//10)*20-110,20,20)
            fill(255, 0, 152)
            tt(z,show[z].x+(v%10)*20,show[z].y-(v//10)*20-110)
        end
    end
    popStyle()
end

function showTotals()
    pushStyle()
    textMode(CORNER)
    font("Courier-Bold")
    text("used     ",50,300)
    text("rotate   ",50,270)
    for z=1,12 do
        text(used[z],100+z*30,300)
        text(rot[z],100+z*30,270)
    end
    text("try count  "..trycount,125,210)
    text("fit count  "..fitcount,125,180)
    text("solutions  "..solution,125,150)
    text("some solutions at 58203, 101421, 144570, 173559",125,120)
    popStyle()
end

function printSolution()
    print("Solution  "..solution.."  at "..trycount)
    print(string.format("Used\n%s",table.concat(used," ")))
    print(string.format("Rot\n%s",table.concat(rot," ")))
    print("======================")
end

function nextboardPosition()
    for z=1,100 do
        if board[z]==0 then
            return(z)
        end
    end
    return(0)
end

function nextpiece(curr,val)
    local loop,dup=true,0
    used[curr]=val rot[curr]=1
    while loop do
        dup=0
        for z=1,(curr-1) do    
            if used[curr]==used[z] then
                dup=1
                used[curr]=used[curr]+1
                break
            end
        end
        if dup==0 then
            loop=false
        end
    end
    return(0)
end

function checkfit()
    local pp=piece local b1=nextopen local p1=used[pieceoffset]
    local p2=rot[pieceoffset] local offset  
    trycount=trycount+1    
    for z=1,#pp[p1][p2] do
        offset=b1+pp[p1][p2][z]
        if board[offset] ~= 0 then
            return(0) -- wont fit
        end
    end    
    for z=1,#pp[p1][p2] do
        offset=b1+pp[p1][p2][z]
        board[offset]=p1
    end    
    here[pieceoffset]=b1
    fitcount=fitcount+1  
    return(1) -- fit ok    
end     
  
function pieceused(val)
    for z=1,12 do
        if used[z]==val then
            return(1)
        end
    end
    return(0)
end

function removepiece()
    local pp=piece local b1=here[pieceoffset] 
    local p1=used[pieceoffset] local p2=rot[pieceoffset]
    for z=1,#pp[p1][p2] do
        offset=b1+pp[p1][p2][z]
        board[offset]=0
    end    
end

function addone()
    local r,lp,u
    while 1 do
        r=rot[pieceoffset]+1
        if r<5 then
            rot[pieceoffset]=r
            return
        end 
        lp=true
        while lp do
            u=used[pieceoffset]+1
            if u<13 then
                if pieceused(u)==0 then
                    used[pieceoffset]=u
                    rot[pieceoffset]=1
                    return
                else
                    used[pieceoffset]=u
                end
            else
                used[pieceoffset]=0
                rot[pieceoffset]=0
                pieceoffset=pieceoffset-1
                removepiece()
                lp=false
                if pieceoffset==0 then
                    exit()
                end
            end
        end
    end
end
