
-- Seismograph

viewer.mode=FULLSCREEN

function setup()
    intensity=10000
    x = {}
    size=WIDTH-30
end

function draw()
    background(0, 255, 127, 255)
    
    strokeWidth(4)
    stroke(255, 0,0)
    line(0,HEIGHT/2,WIDTH,HEIGHT/2)
    
    strokeWidth(2)
    stroke(0, 0, 0, 255)
    
    accY=UserAcceleration.y
    table.insert(x,accY*intensity+HEIGHT/2)
    if #x>size+1 then
        count=0
        for z=#x-size,#x do
            count=count+1
            line(count,x[z-1],count+1,x[z])
        end
        table.remove(x,1)
    else
        for z=2,#x do
            line(z-1,x[z-1],z,x[z])
        end
    end   

    fill(29, 0, 255)
    str=string.format("accY = %6.3f",accY)
    text(str,WIDTH/2,HEIGHT-50)    
end


