
-- Sierpinski cube

viewer.mode=FULLSCREEN

function setup()
    img=readImage(asset.builtin.Blocks.Table)
    fill(255)
    assert(OrbitViewer, "Please include Cameras as a dependency")
    scene = craft.scene()
    v=scene.camera:add(OrbitViewer, vec3(0,0,0), 100, 0, 10000)
    v.rx=30
    v.ry=-45
    skyMaterial=scene.sky.material
    skyMaterial.sky=color(0, 62, 255, 255)
    skyMaterial.horizon=color(99, 255, 0, 255)
    scene.sun.rotation=quat.eulerAngles(20,45,-30)
    cube(0,0,0,27)
end

function update(dt)
    scene:update(dt)
end

function draw()
    update(DeltaTime)
    scene:draw()
    text("Slide your finger to rotate the cube",WIDTH/2,HEIGHT-150)
    text("Sierpinski cube",WIDTH/2,HEIGHT-100)
end

function cube(x,y,z,size)
    local s=size//3
    for x1=-s,s,s do
        for y1=-s,s,s do
            for z1=-s,s,s do
                if (y1~=0 or z1~=0) and (x1~=0 or z1~=0) and (x1~=0 or y1~=0) then
                    if size~=3 then
                        cube(x1+x,y1+y,z1+z,s)
                    else
                        local c=scene:entity()
                        c.position=vec3(x1+x,y1+y,z1+z)
                        c.model = craft.model.cube(vec3(1,1,1))
                        c.material = craft.material(asset.builtin.Materials.Standard)
                        c.material.map = img
                    end
                end
            end           
        end
    end
end
